/**
 * クロスブラウザに対応したメソッドを集めたクラス
 * 
 * @constructor
 */
function CROSS() {

}

/**
 * イベントリスナー追加
 * 
 * @param {Node}
 *            node ノード
 * @param {string}
 *            type イベントタイプ
 * @param {Function}
 *            handler イベントハンドラー
 */
CROSS.prototype.addEvent = function(node, type, handler) {
	if (document.addEventListener) {
		node.addEventListener(type, handler, false);
	} else if (document.attachEvent) {
		node.attachEvent('on' + type, function(evt) {
			handler.call(node, evt);
		});
	}
};

/**
 * 要素上のマウスのX座標
 * 
 * @param {Event}
 *            e マウスイベント
 * @returns {number} 要素上のマウスX座標
 */
CROSS.prototype.getOffsetX = function(e) {

	if (document.all) {
		return e.offsetX;
	} else {
		return e.pageX - e.target.offsetLeft;
	}
};

/**
 * 要素上のマウスのY座標
 * 
 * @param {Event}
 *            e マウスイベント
 * @returns {number} 要素上のマウスY座標
 */
CROSS.prototype.getOffsetY = function(e) {

	if (document.all) {
		return e.offsetY;
	} else {
		return e.pageY - e.target.offsetTop;
	}
};