/**
 * @fileoverview 三目並べゲームメインクラス定義ファイル
 *     <canvas>のonLoadイベントにmain()設定することで、
 *     ゲームを開始する
 */

/**
 * 三目並べゲームメインオブジェクト onClick関数の中では、thisが使えないので、グローバル変数で持っておく。
 * 
 * @type {ThreeEyeGame}
 */
var g_this;

var g_control;

/**
 * 三目並べゲームを開始する。
 */
function main() {
	g_this = new ThreeEyeGame();
}

/**
 * 三目並べゲームメインクラス
 * 
 * @constructor
 */
function ThreeEyeGame() {
	// onLoadしてからじゃないと、エレメントを取得できない。
	// 本当なら上のグローバル変数宣言でnewしたいけど、メインクラスの
	// コンストラクタの最初の処理で実行する。
	g_control = new ThreeEyeGameControlManage();
	
	/**
	 * 三目ゲームデータ
	 * 
	 * @type {ThreeEyeGameData}
	 */
	this.infomation = new ThreeEyeGameData();
	/**
	 * 三目ゲーム描画
	 * 
	 * @type {ThreeEyeGameDrawer}
	 */
	this.drawer = new ThreeEyeGameDrawer();

	/**
	 * 三目ゲームマネージャ
	 * 
	 * @type {ThreeEyeGameManage}
	 */
	this.manager = new ThreeEyeGameManage();

	/**
	 * ロガー
	 * @type {ThreeEyeGameLogger}
	 */
	this.logger = new ThreeEyeGameLogger();
	
	/**
	 * タイマーID
	 * @type {number};
	 */
	this.timer_id = -1;
	
	// キャンパスクリックハンドラ登録
	var canvas = document.getElementById(THREE_EYE_GAME_DEFINE.CANVAS_ID);
	var cross = new CROSS();
	cross.addEvent(canvas, "click", this.canvasClickHandler);
	// ボタンクリックハンドラ登録
	var start_button = document.getElementById(THREE_EYE_GAME_DEFINE.START_BUTTON_ID);
	cross.addEvent(start_button, "click", this.startButtonClickHandler);
	
	// 描画
	this.drawer.draw(this.infomation);
	// ログ表示
	this.logger.write(this.infomation, this.manager);
	
}

/**
 * 三目ゲームクリックハンドラ
 * 
 * @param {Event}
 *            e マウスイベント
 * @returns {boolean} 戻り値
 */
ThreeEyeGame.prototype.canvasClickHandler = function(e) {
	// 試合中でコンピュータの番だったら何もしない。
	if(g_this.manager.getScene() == THREE_EYE_GAME_DEFINE.SCENE_PLAY &&
		g_this.manager.getCurrentPlayer().getOperation() == THREE_EYE_GAME_DEFINE.PLAY_COM){
		return false;
	}
	
	// 状態変更
	g_this.manager.clickHandler(e, g_this.infomation, g_this.drawer);
	
	// 描画
	g_this.drawer.draw(g_this.infomation);
	// ログ表示
	g_this.logger.write(g_this.infomation, g_this.manager);
	
	// コンピュータの番ならタイマー起動
	if(g_this.manager.isTimerStart()){
		g_this.timerStart();
	}

	return false;
};

/**
 * スタートボタンクリックハンドラ
 * @param {Event} e マウスイベント
 * @returns {boolean} 戻り値
 */
ThreeEyeGame.prototype.startButtonClickHandler = function(e){
	// コントロールの値を更新
	g_control.updateControl();
	
	// 作り直し
	g_this.infomation = new ThreeEyeGameData();
	g_this.drawer = new ThreeEyeGameDrawer();
	g_this.manager = new ThreeEyeGameManage();
	
	// コンピュータの番
	g_this.manager.actionComPlay(g_this.infomation);

	// 描画
	g_this.drawer.draw(g_this.infomation);
	// ログ表示
	g_this.logger.write(g_this.infomation, g_this.manager);
	
	// コンピュータの番ならタイマー起動
	if(g_this.manager.isTimerStart()){
		g_this.timerStart();
	}
	return false;
};

ThreeEyeGame.prototype.timerStart = function(){
	this.timer_id = setTimeout(this.timerHandler, THREE_EYE_GAME_DEFINE.TIMER_MSEC);
};

ThreeEyeGame.prototype.timerStop = function(){
	clearTimeout(this.timer_id);
};

ThreeEyeGame.prototype.timerHandler = function(){
	// タイマー停止
	g_this.timerStop();
	
	// コンピュータの番
	g_this.manager.actionComPlay(g_this.infomation);

	// 描画
	g_this.drawer.draw(g_this.infomation);
	// ログ表示
	g_this.logger.write(g_this.infomation, g_this.manager);
	
	// コンピュータの番ならタイマー起動
	if(g_this.manager.isTimerStart()){
		g_this.timerStart();
	}	
};