/**
 * 三目並べゲーム分析クラス
 * @constructor
 */
function ThreeEyeGameAnalyzer (){
		
}


/**
 * 置くマスを取得
 * @param {ThreeEyeGameManage} manage 三目並べ管理
 * @param {ThreeEyeGameData} data 三目並べゲームデータ
 * @returns {ThreeEyeGameMassData} 置くマス
 */
ThreeEyeGameAnalyzer.prototype.getPutMass = function(manage, data){
	
	// 現在のプレイヤーを取得
	var my_id = manage.getCurrentPlayer().getId();
	
	// 他のプレイヤーが置いてあるか？
	if(!this.isAnotherPlayerPutted(my_id, data.getBoardData())){
		// 置いてなければ真中に置く
		return this.getCenterMass(data.getBoardData());
	}

	// 他のプレイヤーが置いてあるか？
	if(!this.isAnotherPlayerPutted(my_id, data.getBoardData())){
		// 置いてなければ真中に置く
		return this.getCenterMass(data.getBoardData());
	}
	
	// 自分がそろうところを返す
	var mass = this.getCompMass(data.getBoardData(), my_id, g_control.getCompNum());
	if(mass != null){
		return mass[0];
	}
	
	// 相手がそろうところを返す
	mass = this.getAnotherPlayerCompMass(data.getBoardData(), manage, g_control.getCompNum());
	if(mass != null){
		return mass[Math.floor( Math.random() * mass.length)];
	}
	
	// 相手がリーチのところを返す
	mass = this.getAnotherPlayerCompMass(data.getBoardData(), manage, g_control.getCompNum() - 1);
	if(mass != null){
		return mass[Math.floor( Math.random() * mass.length)];
	}

	// 自分がリーチところを返す
	mass = this.getCompMass(data.getBoardData(), my_id, g_control.getCompNum() - 1);
	if(mass != null){
		return mass[0];
	}
	
	// 相手の近くで適当な空白を返す
	mass = this.getAnotherPlayerMass(my_id, data.getBoardData());
	if(mass != null){
		return mass;
	}
	
	// どっか空白を返す
	var board_h = data.getBoardData().getHeightLength();
	var board_w = data.getBoardData().getWidhtLength();
	
	for(var ii = 0; ii < board_h; ii ++){
		for(var jj = 0; jj < board_w; jj++){
			mass = data.getBoardData().getMassData(jj, ii);
			var status = mass.getMassStatus();
			if(status == THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
				return mass;
			}
		}
	}
	
	return null;
};


/**
 * 他のプレイヤーが置いてあるマスをランダムで選び、
 * その周りにある空白マスをランダムで返す。
 * @param {number} my_id 現在のプレイヤー
 * @param {ThreeEyeGameBoardData} board 盤
 */
ThreeEyeGameAnalyzer.prototype.getAnotherPlayerMass = function(my_id, board){

	var mass_list = [];
	var mass_list_cnt = 0;
	
	var board_h = board.getHeightLength();
	var board_w = board.getWidhtLength();

	for(var ii = 0; ii < board_h; ii ++){
		for(var jj = 0; jj < board_w; jj++){
			var mass = board.getMassData(jj, ii);
			var status = mass.getMassStatus();
			// 空白じゃないマス
			if(status > THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
				// 自分のマスじゃない
				if(status != my_id){
					// 配列に保持
					mass_list[mass_list_cnt] = mass;
					mass_list_cnt++;
				}
			}
			
		}
	}

	// 
	for(var ii = 0; ii < 999; ii++){
		// ランダムで配列のインデックスを取得
		var rand_index = Math.floor( Math.random() * mass_list.length);
		// マスの周りにある空白マスをもらう。
		var ret_mass = this.getAroundMassRandom(board, mass_list[rand_index]);
		if(ret_mass != null){
			return ret_mass;
		}
	}
	
	return null;
};

/**
 * 自分以外の誰かがそろうマスを返す
 * @param {ThreeEyeGameBoardData} board 盤
 * @param {ThreeEyeGameManage} manage 三目並べ管理
 * @param {number} comp_num 揃えるマス数
 * @returns {Array.<ThreeEyeGameMassData>} 違うプレイヤーが揃うマス
 */
ThreeEyeGameAnalyzer.prototype.getAnotherPlayerCompMass = function(board, manage, comp_num){

	var player_length = g_control.getPlayerNum();

	var my_id = manage.getCurrentPlayer().getId();
	
	for(var ii = 0; ii < player_length; ii++){
		var player = manage.getPlayer(ii);
	    // 自分以外のプレイヤー
		if(player.getId() != my_id){
			// 揃っているマスを取得
	    	var mass = this.getCompMass(board, player.getId(), comp_num);
	    	if(mass != null){
	    		return mass;
	    	}
	    }
	}
	
	return null;
};

/**
 * 渡したプレイヤーが揃うマスがを返す
 * @param {ThreeEyeGameBoardData} board 盤
 * @param {number} my_id プレイヤーID
 * @param {number} comp_num 揃えるマス数
 * @returns {Array.<ThreeEyeGameMassData>} 揃うマス
 */
ThreeEyeGameAnalyzer.prototype.getCompMass = function(board, my_id, comp_num){

	var copy_board = this.getCopyBoard(board);
	
	var board_h = copy_board.getHeightLength();
	var board_w = copy_board.getWidhtLength();

	var line_judge = new ThreeEyeGameLineJudge();

	var ret_mass_list = [];
	var ret_mass_list_cnt = 0;
	
	for(var ii = 0; ii < board_h; ii ++){
		for(var jj = 0; jj < board_w; jj++){
			var mass = copy_board.getMassData(jj, ii);
			var status = mass.getMassStatus();
			if(status == THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
				mass.setMassStatus(my_id);
				var result = line_judge.getLineNumResult(copy_board, mass);
				// 揃うマスがあったら
				if(result.max_count >= comp_num){
					ret_mass_list[ret_mass_list_cnt] = board.getMassData(jj, ii);
					ret_mass_list_cnt++;
				}
				// スペースに戻す
				mass.setMassStatus(THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE);
			}
		}
	}

	if(ret_mass_list.length >= 1){
		return ret_mass_list;
	}
	return null;
};

/**
 * 真ん中のマスを返す
 * @param {ThreeEyeGameBoardData} board 盤
 * @returns {ThreeEyeGameMassData} 中央マス
 */
ThreeEyeGameAnalyzer.prototype.getCenterMass = function(board){
	
	var board_h = board.getHeightLength();
	var board_w = board.getWidhtLength();

	var hh = Math.floor(board_h / 2);
	var ww = Math.floor(board_w / 2);
	
	return board.getMassData(ww, hh);
};

/**
 * 渡されたプレイヤーと違うプレイヤーがすでに置いてあるかどうか
 * @param {number} my_id 自分
 * @param {ThreeEyeGameBoardData} board 盤
 * @returns {boolean} すでに違うプレイヤーが置いてあるか
 */
ThreeEyeGameAnalyzer.prototype.isAnotherPlayerPutted = function(my_id, board){

	
	var board_h = board.getHeightLength();
	var board_w = board.getWidhtLength();

	for(var ii = 0; ii < board_h; ii ++){
		for(var jj = 0; jj < board_w; jj++){
			var mass = board.getMassData(jj, ii);
			var status = mass.getMassStatus();
			if(status > THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
				if(status != my_id){
					return true;
				}
			}
		}
	}

	return false;
};

/**
 * コピー盤取得
 * @param {ThreeEyeGameBoardData} board 盤
 * @returns {ThreeEyeGameBoardData} コピー盤
 */
ThreeEyeGameAnalyzer.prototype.getCopyBoard = function(board){

	var copy_board = new ThreeEyeGameBoardData();
	
	var board_h = board.getHeightLength();
	var board_w = board.getWidhtLength();

	// ボード状態をコピーする
	for(var ii = 0; ii < board_h; ii ++){
		for(var jj = 0; jj < board_w; jj++){
			var mass = board.getMassData(jj, ii);
			var copy_mass = copy_board.getMassData(jj, ii);
			copy_mass.setMassStatus(mass.getMassStatus());
		}
	}
	
	return copy_board;
};

/**
 * 指定されたマスの周りにある空白マスをランダムで返す
 * @param {ThreeEyeGameBoardData} board
 * @param {ThreeEyeGameMassData} mass
 * @returns {ThreeEyeGameMassData} マス
 */
ThreeEyeGameAnalyzer.prototype.getAroundMassRandom = function(board, mass){
	
	// 周りにスペースマスがなかった場合はnullを返す
	var count = 0;
	
	var get_mass = null;
	while(get_mass == null){
	
		count++;
		if(count > 99){
			return null;
		}
		var randnum = THREE_EYE_GAME_DEFINE.DIRECTION_UP + Math.floor( Math.random() * THREE_EYE_GAME_DEFINE.DIRECTION_RIGHT_DOWN + 1);
		
		get_mass = board.getDirectionMass(mass, randnum);
		if(get_mass == null){
			continue;
		}
		var status = get_mass.getMassStatus();
		if(status == THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
			// ループ終了
		}else{
			get_mass = null;
		}
	}
	
	return get_mass;
	
};

/**
 * 再起処理
 * @param {ThreeEyeGameManage} manage 三目並べ管理
 * @param {ThreeEyeGameBoardData} board 盤
 * @param {number} value 評価値
 * @returns {number} 評価値
 */
/*
ThreeEyeGameAnalyzer.prototype.getPutAnalyze = function(manage, board, value){

	// 現在のプレイヤーを取得
	var my_id = manage.getCurrentPlayer().getId();

	// 自分がそろうところを返す
	var mass = this.getCompMass(board, my_id);
	if(mass != null){
		return value + 1;
	}
	
	// 相手がそろうところを返す
	mass = this.getAnotherPlayerCompMass(board, manage);
	if(mass != null){
		return value + 2;
	}

	// 個数と揃うライン数が同じマスを返す
	var mass_result_list = this.getCntLineMaxMassList(board, manage);
	if(mass_result_list.length >= 1){
		var ret_value_list = [];
		// 複数マスあった場合、ボードに相手を置いてみて判定用の関数を呼ぶ
		// ほぼこの関数と同じだが、返ってくるのがマスじゃなくて数字
		for(var ii = 0; ii < mass_result_list.length; ii++){
			var copy_mass = board.getMassData(mass_result_list[ii].mass.getWidthIndex(), mass_result_list[ii].mass.getHeightIndex());
			copy_mass.setMassStatus(mass_result_list[ii].mass.getMassStatus());
			ret_value_list[ii] = this.getPutAnalyze(manage, board, value + 1);
		}

		
		var sum_value = 0;
		for(var ii = 0; ii < ret_value_list.length; ii++){
			sum_value = sum_value + ret_value_list[ii];
		}
		
		return sum_value;
		// 一番帰ってきた数字が少ないマスを返す。
		
	
	    // それでお同じ数だったら、ランダムで返す。
	}
	return value + 3;
	
};*/

/**
 * 置くマスを取得
 * @param {ThreeEyeGameManage} manage 三目並べ管理
 * @param {ThreeEyeGameData} data 三目並べゲームデータ
 * @returns {ThreeEyeGameMassData} 置くマス
 */
/*
ThreeEyeGameAnalyzer.prototype.getPutMass2 = function(manage, data){

	// 現在のプレイヤーを取得
	var my_id = manage.getCurrentPlayer().getId();
	
	// 他のプレイヤーが置いてあるか？
	if(!this.isAnotherPlayerPutted(my_id, data.getBoardData())){
		// 置いてなければ真中に置く
		return this.getCenterMass(data.getBoardData());
	}
	
	// 自分がそろうところを返す
	var mass = this.getCompMass(data.getBoardData(), my_id);
	if(mass != null){
		return mass;
	}
	
	// 相手がそろうところを返す
	mass = this.getAnotherPlayerCompMass(data.getBoardData(), manage);
	if(mass != null){
		return mass;
	}
	
	// 個数と揃うライン数が同じマスを返す
	var mass_result_list = this.getCntLineMaxMassList(data.getBoardData(), manage);
	if(mass_result_list.length >= 1){
		var ret_value_list = [];
		// 複数マスあった場合、ボードに相手を置いてみて判定用の関数を呼ぶ
		// ほぼこの関数と同じだが、返ってくるのがマスじゃなくて数字
		var copy_board = this.getCopyBoard(data.getBoardData());
		for(var ii = 0; ii < mass_result_list.length; ii++){
			var copy_mass = copy_board.getMassData(mass_result_list[ii].mass.getWidthIndex(), mass_result_list[ii].mass.getHeightIndex());
			copy_mass.setMassStatus(mass_result_list[ii].mass.getMassStatus());
			ret_value_list[ii] = this.getPutAnalyze(manage, copy_board, 0);
		}
		
		var min_value = 999999;
		var min_index = 0;
		// 一番帰ってきた数字が少ないマスを返す。
		for(var ii = 0; ii < ret_value_list.length; ii++){
			if(ret_value_list[ii] < min_value){
				min_value = ret_value_list[ii];
				min_index = ii;
			}
		}
		
	    // それでお同じ数だったら、ランダムで返す。
		
		var ret_mass = data.getBoardData().getMassData(mass_result_list[min_index].mass.getWidthIndex(), mass_result_list[min_index].mass.getHeightIndex());
		return ret_mass;
	}
	var ret_mass = data.getBoardData().getMassData(mass_result_list[0].mass.getWidthIndex(), mass_result_list[0].mass.getHeightIndex());
	return ret_mass;
};
*/

/**
 * 指定されたマスをプレイヤーごとに配置結果を調べ、最大結果を返す
 * @param {ThreeEyeGameManage} manage
 * @param {ThreeEyeGameBoardData} board 盤
 * @param {ThreeEyeGameMassData} mass 調べるマス
 * @returns {Array.<JugeLineResult>} 結果リスト
 */
/*
ThreeEyeGameAnalyzer.prototype.getPlayerMassList = function(manage, board, mass){
	var mass_list = [];
    var mass_list_cnt = 0;
	
	var max_result = new JugeLineResult(0, 0, 0);
	
	var line_judge = new ThreeEyeGameLineJudge();

	var player_length = g_control.getPlayerNum();
	
	// プレイヤー数分ループ
	for(var ii = 0; ii < player_length; ii++){
		var player = manage.getPlayer(ii);
	    var plyaer_id = player.getId();
		mass.setMassStatus(plyaer_id);
		// プレイヤーごとに置いて、結果を取得
		var result = line_judge.getLineNumResult(board, mass);
	    if(max_result.max_count < result.max_count){
	    	if(max_result.line_num < result.line_num){
	    		max_result = result;
	    	}
	    }
	    
	    mass_list[mass_list_cnt] = result;
	    mass_list_cnt++;
		
	}
	mass.setMassStatus(THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE);
	
	
	var ret_mass_list = [];
	var ret_mass_cnt = 0;
	for(var ii = 0; ii < mass_list.length; ii++){
    	if(mass_list[ii].max_count == max_result.max_count &&
    		mass_list[ii].line_num == max_result.line_num){
    		ret_mass_list[ret_mass_cnt] = mass_list[ii];
    		ret_mass_cnt++;
    	}
	}
	
	return ret_mass_list;
};
*/

/**
 * スペースマスの中で、一番置かれたらまずいマスを返す。
 * @param {ThreeEyeGameBoardData} board
 * @param {ThreeEyeGameManage} manage
 * @returns {Array.<ResultAndMass>}
 */
/*
ThreeEyeGameAnalyzer.prototype.getCntLineMaxMassList = function(board, manage){
	var mass_list = [];
	var mass_cnt_list = 0;
	
	var copy_board = this.getCopyBoard(board);
	
	var board_h = copy_board.getHeightLength();
	var board_w = copy_board.getWidhtLength();

	for(var ii = 0; ii < board_h; ii ++){
		for(var jj = 0; jj < board_w; jj++){
			var mass = copy_board.getMassData(jj, ii);
			var status = mass.getMassStatus();
			if(status == THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
				// プレイヤーごとの結果を受け取る
				var player_mass_list = this.getPlayerMassList(manage, copy_board, mass);
				for(var player_mass_index = 0; player_mass_index < player_mass_list.length; player_mass_index++){
					var mass_result = new ResultAndMass();
					mass_result.result = player_mass_list[player_mass_index];
					mass.setMassStatus(player_mass_list[player_mass_index].player_id);
					mass_result.mass = mass;
					mass_list[mass_cnt_list] = mass_result;
					mass_cnt_list++;
				}
			}
		}
	}
	
	// 最大値取得
	var max_result = new JugeLineResult(0, 0, 0);
	
	for(var ii = 0; ii < mass_list.length; ii++){
		if(max_result.max_count < mass_list[ii].result.max_count){
	    	if(max_result.line_num < mass_list[ii].result.line_num){
	    		max_result = mass_list[ii];
	    	}
	    }
	}
	
	// 最大結果を取得
	var ret_mass_list = [];
	var ret_mass_cnt = 0;
	for(var ii = 0; ii < mass_list.length; ii++){
    	if(mass_list[ii].result.max_count == max_result.result.max_count &&
    		mass_list[ii].result.line_num == max_result.result.line_num){
    		ret_mass_list[ret_mass_cnt] = mass_list[ii];
    	}
	}
	
	return ret_mass_list;

};
*/

/**
 * 
 * @constructor
 */
//function ResultAndMass(){
//	/**
//	 * 直線調査結果
//	 * @type {JugeLineResult}
//	 */
//	this.result;
//	/**
//	 * 開始マス
//	 * @type {ThreeEyeGameMassData}
//	 */
//	this.mass;
//}



/**
ThreeEyeGameAnalyzer.prototype.getMassAnalyze = function(manage, board, mass){

	
	var line_judge = new ThreeEyeGameLineJudge();
	for(var player_index = 0; player_index < player_length; player_index++){
		var player = manage.getPlayer(player_index);
		var id = player.getId();
		mass.setMassStatus(id);
		var result = line_judge.getLineNumResult(copy_board, mass);
	    
	}
};

ThreeEyeGameAnalyzer.prototype.getBoardAnalyze = function(manage, data){
	
	var analyze_mass_list = [];
	var mass_list_cnt = 0;
	
	var board = this.getCopyBoard(data.getBoardData());
	
	var board_h = board.getHeightLength();
	var board_w = board.getWidhtLength();

	for(var ii = 0; ii < board_h; ii ++){
		for(var jj = 0; jj < board_w; jj++){
			var mass = board.getMassData(jj, ii);
			var status = mass.getMassStatus();
			if(status == THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
				analyze_mass_list[mass_list_cnt] = getMassAnalyze(manage, board, mass);
			}
		}
	}

};
*/



//ThreeEyeGameAnalyzer.prototype.getPutMass1 = function(manage, data){
//	
//	var my_id = manage.getCurrentPlayer().getId();
//		
//	var player_length = g_control.getPlayerNum();
//	
//	var analyze_board = new ThreeEyeGameBoardData();
//	var copy_board = new ThreeEyeGameBoardData();
//	
//	var board = data.getBoardData();
//	
//	
//	var board_h = board.getHeightLength();
//	var board_w = board.getWidhtLength();
//
//	// ボード状態をコピーする
//	for(var ii = 0; ii < board_h; ii ++){
//		for(var jj = 0; jj < board_w; jj++){
//			var mass = board.getMassData(jj, ii);
//			var copy_mass = copy_board.getMassData(jj, ii);
//			copy_mass.setMassStatus(mass.getMassStatus());
//		}
//	}
//
//	
//	var start_space_h = 0;
//	var start_space_w = 0;
//	
//	// スペースマスを見つける
//	for(var hh = 0; hh < board_h; hh ++){
//		for(var ww = 0; ww < board_w; ww++){
//			var mass = copy_board.getMassData(ww, hh);
//			var status = mass.getMassStatus();
//			if(status == THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
//				start_space_h = hh;
//				start_space_w = ww;
//				
//				// プレイヤーの数だけループ
//				var max_count = 0;
//				for(var player_index = 0; player_index < player_length; player_index++){
//					var player = manage.getPlayer(player_index);
//					var id = player.getId();
//					mass.setMassStatus(id);
//					
//					var line_judge = new ThreeEyeGameLineJudge();
//					
//					var result = line_judge.getLineNumResult(copy_board, mass);
//					// 自分がそろうのであればそこに置く
//					if(result.max_count >= g_control.getCompNum() && id == my_id){
//						return board.getMassData(ww, hh);
//					}
//					
//					// 相手がそろうのであればそこに置く
//					if(result.max_count >= g_control.getCompNum()){
//						return board.getMassData(ww, hh);
//					}
//					
//					var count = 0;
//					
//					// 相手がリーチならそこに置く
//					if(result.max_count == g_control.getCompNum() - 1 && result.line_num >= 2){
//						count += 1;
//					}
//
//					// 自分がリーチなら全部見終わった後に置く
//					if(result.max_count == g_control.getCompNum() - 1 && result.line_num >= 2 && id == my_id){
//						count += 1;
//					}
//					
//					// 相手がリーチならそこに置く
//					if(result.max_count == g_control.getCompNum() - 1){
//						count += 1;
//					}
//
//					// 自分がリーチなら全部見終わった後に置く
//					if(result.max_count == g_control.getCompNum() - 1 && id == my_id){
//						count += 1;
//					}
//
//					// それ以外は個数を保持
//					var sum = result.max_count * result.line_num;
//					count = count + sum;
//
//					max_count = max_count + count;
//					
//					// スペースに戻す
//					mass.setMassStatus(THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE);
//					
//				}
//				
//				// 値を解析用の盤に格納
//				var analyze_mass = analyze_board.getMassData(ww, hh);
//				analyze_mass.setMassStatus(max_count);
//			}
//		}
//	}
//	
//	
//	// 一番値が大きいマスを取得
//	var ret_mass = analyze_board.getMassData(start_space_w, start_space_h);
//	for(var hh = 0; hh < board_h; hh ++){
//		for(var ww = 0; ww < board_w; ww++){
//			var mass = analyze_board.getMassData(ww, hh);
//			var status = mass.getMassStatus();
//			var ret_mass_status = ret_mass.getMassStatus();
//			if(status > ret_mass_status){
//				ret_mass = mass;
//			}
//		}
//	}
//	
////	// 最高が4の場合、すでに置かれているマスの周りのどこかに置く
////	if(ret_mass.getMassStatus() == 4){
////		for(var hh = 0; hh < board_h; hh ++){
////			for(var ww = 0; ww < board_w; ww++){
////				var mass = copy_board.getMassData(ww, hh);
////				var status = mass.getMassStatus();
////				if(status != THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
////					var get_mass = this.getAroundMassRandom(copy_board, mass);
////					if(get_mass != null){
////						ret_mass = get_mass;
////					}
////				}
////			}
////		}
////	}
//	
//	// 全部スペースならランダムで置く
//	var space_num = 0;
//	for(var hh = 0; hh < board_h; hh ++){
//		for(var ww = 0; ww < board_w; ww++){
//			var mass = copy_board.getMassData(ww, hh);
//			var status = mass.getMassStatus();
//			if(status == THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE){
//				space_num++;
//			}
//		}
//	}
//	if(space_num == board_h * board_w){
//		var rand_h = Math.floor( Math.random() * board_h);
//		var rand_w = Math.floor( Math.random() * board_w);
//		ret_mass = copy_board.getMassData(rand_w, rand_h);
//	}
//	
//	
//	// 置くマスを返す
//	var ret_w = ret_mass.getWidthIndex();
//	var ret_h = ret_mass.getHeightIndex();
//	return board.getMassData(ret_w, ret_h);
//};

/**
 * 8方向の中にある一番多い個数を取得。
 *     フラグを立てると、個数の合計を返す
 * @param {ThreeEyeGameBoardData} board
 * @param {boolean} is_sum
 * @returns {number} 方向内の個数
 */
//ThreeEyeGameAnalyzer.prototype.getMaxCount = function(board, is_sum){
//	
//	var line_judge = new ThreeEyeGameLineJudge();
//	
//	var board_h = board.getHeightLength();
//	var board_w = board.getWidhtLength();
//
//	var max_count = 0;
//	
//	for(var hh = 0; hh < board_h; hh ++){
//		for(var ww = 0; ww < board_w; ww++){
//			var mass = board.getMassData(ww, hh);
//			var count = line_judge.getMaxCompNum(board, mass);
//			if(is_sum){
//				max_count += count;
//			}else{
//				if(count > max_count){
//					max_count = count;
//				}
//			}
//		}	
//	}
//	
//	return max_count;
//};


