/**
 * 三目並べゲーム盤データクラス
 * 
 * @constructor
 */
function ThreeEyeGameBoardData() {
	/**
	 * マスデータ配列
	 * 
	 * @type {Array.<Array.<ThreeEyeGameMassData>>}
	 */
	this.massArray = [];

	// マスデータ初期化
	for ( var ii = 0; ii < g_control.getBoardHeightNum(); ii++) {
		this.massArray[ii] = [];
		for ( var jj = 0; jj < g_control.getBoardWidthNum(); jj++) {
			this.massArray[ii][jj] = new ThreeEyeGameMassData(jj, ii);
		}
	}
}

/**
 * マスデータ取得
 * 
 * @param {number}
 *            x 横方向インデックス
 * @param {number}
 *            y 縦方向インデックス
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getMassData = function(x, y) {

	var height_index = this.getHeightLength();
	var width_index = this.getWidhtLength();

	for ( var ii = 0; ii < height_index; ii++) {
		for ( var jj = 0; jj < width_index; jj++) {

			var mass = this.massArray[ii][jj];

			var h_index = mass.getHeightIndex();
			var w_index = mass.getWidthIndex();

			if (h_index == y && w_index == x) {
				return mass;
			}
		}
	}

	return null;
};

/**
 * 縦マス数取得
 * 
 * @returns {number} 縦マス数
 */
ThreeEyeGameBoardData.prototype.getHeightLength = function() {
	return this.massArray.length;
};

/**
 * 横マス数取得
 * 
 * @returns {number} 横マス数
 */
ThreeEyeGameBoardData.prototype.getWidhtLength = function() {
	return this.massArray[0].length;
};

/**
 * 指定方向マス取得
 * 
 * @param mass_data
 * @param direction
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getDirectionMass = function(mass_data,
		direction) {

	var mass = null;

	if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_UP) {
		mass = this.getUpMass(mass_data);
	} else if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_DOWN) {
		mass = this.getDownMass(mass_data);
	} else if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_LEFT) {
		mass = this.getLeftMass(mass_data);
	} else if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_RIGHT) {
		mass = this.getRightMass(mass_data);
	} else if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_LEFT_UP) {
		mass = this.getLeftUpMass(mass_data);
	} else if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_RIGHT_UP) {
		mass = this.getRightUpMass(mass_data);
	} else if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_LEFT_DOWN) {
		mass = this.getLeftDownMass(mass_data);
	} else if (direction == THREE_EYE_GAME_DEFINE.DIRECTION_RIGHT_DOWN) {
		mass = this.getRightDownMass(mass_data);
	}

	return mass;
};

/**
 * 上段マス取得 引数で渡されたマスの、上にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getUpMass = function(mass_data) {
	var x = mass_data.getWidthIndex();
	var y = mass_data.getHeightIndex() - 1;

	var mass = this.getMassData(x, y);
	return mass;
};

/**
 * 下段マス取得 引数で渡されたマスの、下にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getDownMass = function(mass_data) {
	var x = mass_data.getWidthIndex();
	var y = mass_data.getHeightIndex() + 1;

	var mass = this.getMassData(x, y);
	return mass;
};

/**
 * 左列マス取得 引数で渡されたマスの、左にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getLeftMass = function(mass_data) {
	var x = mass_data.getWidthIndex() - 1;
	var y = mass_data.getHeightIndex();

	var mass = this.getMassData(x, y);
	return mass;
};

/**
 * 右列マス取得 引数で渡されたマスの、右にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getRightMass = function(mass_data) {
	var x = mass_data.getWidthIndex() + 1;
	var y = mass_data.getHeightIndex();

	var mass = this.getMassData(x, y);
	return mass;
};

/**
 * 左上マス取得 引数で渡されたマスの、左上にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getLeftUpMass = function(mass_data) {
	var x = mass_data.getWidthIndex() - 1;
	var y = mass_data.getHeightIndex() - 1;

	var mass = this.getMassData(x, y);
	return mass;
};

/**
 * 右上マス取得 引数で渡されたマスの、右上にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getRightUpMass = function(mass_data) {
	var x = mass_data.getWidthIndex() + 1;
	var y = mass_data.getHeightIndex() - 1;

	var mass = this.getMassData(x, y);
	return mass;
};

/**
 * 左下マス取得 引数で渡されたマスの、左下にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getLeftDownMass = function(mass_data) {
	var x = mass_data.getWidthIndex() - 1;
	var y = mass_data.getHeightIndex() + 1;

	var mass = this.getMassData(x, y);
	return mass;
};

/**
 * 右下マス取得 引数で渡されたマスの、右下にあるマスを返す。
 * 
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @returns {ThreeEyeGameMassData} マスデータ
 */
ThreeEyeGameBoardData.prototype.getRightDownMass = function(mass_data) {
	var x = mass_data.getWidthIndex() + 1;
	var y = mass_data.getHeightIndex() + 1;

	var mass = this.getMassData(x, y);
	return mass;
};