/**
 * 盤描画クラス
 * 
 * @constructor
 */
function ThreeEyeGameBoardDrawer() {
	/**
	 * コンテキスト
	 * 
	 * @type {CanvasRenderingContext2D}
	 */
	this.ctx = document.getElementById(THREE_EYE_GAME_DEFINE.CANVAS_ID)
			.getContext('2d');

	/**
	 * マス描画
	 * 
	 * @type {ThreeEyeGameMassDrawer}
	 */
	this.mass = new ThreeEyeGameMassDrawer();
}

/**
 * 盤描画
 * 
 * @param {ThreeEyeGameBoardData}
 *            data
 */
ThreeEyeGameBoardDrawer.prototype.draw = function(data) {

	var height_num = data.getHeightLength();
	var width_num = data.getWidhtLength();

	// 全マス取得
	for ( var ii = 0; ii < height_num; ii++) {
		for ( var jj = 0; jj < width_num; jj++) {
			// マス取得
			var mass = data.getMassData(jj, ii);
			// マス描画
			this.mass.draw(mass);
		}
	}

};