/**
 * 盤の縦数選択クラス
 * @constructor
 */
function ThreeEyeGameControlBoardHeightSelect(){
	/**
	 * 盤の縦数<select>要素
	 * @type {Element}
	 */
	this.board_height_num_select = document.getElementById(THREE_EYE_GAME_DEFINE.BOARD_HEIGHT_NUM_SELECT_ID);
	/**
	 * 盤の縦数
	 * @type {number}
	 */
	this.board_height_num = 3;
	
	// 盤の縦数更新
	this.updateBoardHeightNum();
}


/**
 * 盤の縦数取得
 * @returns {number} 盤の縦数
 */
ThreeEyeGameControlBoardHeightSelect.prototype.getBoardHeightNum = function(){
	return this.board_height_num;
};

/**
 * 盤の縦数更新
 * 
 */
ThreeEyeGameControlBoardHeightSelect.prototype.updateBoardHeightNum = function(){

	var value = this.board_height_num_select.value;
	this.board_height_num = Number(value);
};
