/**
 * 盤の幅数選択クラス
 * @constructor
 */
function ThreeEyeGameControlBoardWidthSelect() {
	/**
	 * 盤の幅数<select>要素
	 * 
	 * @type {Element}
	 */
	this.board_width_num_select = document
			.getElementById(THREE_EYE_GAME_DEFINE.BOARD_WIDTH_NUM_SELECT_ID);
	/**
	 * 盤の幅数
	 * 
	 * @type {number}
	 */
	this.board_width_num = 3;

	// 盤の幅数更新
	this.updateBoardWidthNum();
}

/**
 * 盤の幅数取得
 * 
 * @returns {number} 盤の幅数
 */
ThreeEyeGameControlBoardWidthSelect.prototype.getBoardWidthNum = function() {
	return this.board_width_num;
};

/**
 * 盤の幅数更新
 * 
 */
ThreeEyeGameControlBoardWidthSelect.prototype.updateBoardWidthNum = function() {

	var value = this.board_width_num_select.value;
	this.board_width_num = Number(value);
};