/**
 * いくつ並べればいいか選択クラス
 * @constructor
 */
function ThreeEyeGameControlCompleteSelect() {
	/**
	 * いくつ並べればいいか<select>要素
	 * @type {Element}
	 */
	this.comp_select_element = document.getElementById(THREE_EYE_GAME_DEFINE.COMP_NUM_SELECT_ID);
	/**
	 * いくつ並べればいいか
	 * @type {number}
	 */
	this.comp_num = 3;
	
	// 初期値を設定
	this.updateCompNum();
}

/**
 * いくつ並べればいいか取得
 * @returns {number} いくつ並べればいいか
 */
ThreeEyeGameControlCompleteSelect.prototype.getCompNum = function() {
	return this.comp_num;
};

/**
 * いくつ並べればいいかの数を更新する
 */
ThreeEyeGameControlCompleteSelect.prototype.updateCompNum = function() {

	var value = this.comp_select_element.value;
	this.comp_num = Number(value);
};