/**
 * コントロール管理クラス
 * @constructor
 */
function ThreeEyeGameControlManage(){
	/**
	 * いくつ並べればいいか選択クラス
	 * @type {ThreeEyeGameControlCompleteSelect}
	 */
	this.comp_num_select = new ThreeEyeGameControlCompleteSelect();
	/**
	 * プレイヤー人数選択クラス
	 * @type {ThreeEyeGameControlPlayerSelect}
	 */
	this.player_num_select = new ThreeEyeGameControlPlayerSelect();
	/**
	 * 盤の縦数選択クラス
	 * @type {ThreeEyeGameControlBoardHeightSelect}
	 */
	this.board_height_select = new ThreeEyeGameControlBoardHeightSelect();
	/**
	 * 盤の幅数選択クラス
	 * @type {ThreeEyeGameControlBoardWidthSelect}
	 */
	this.board_width_select = new ThreeEyeGameControlBoardWidthSelect();
	
	/**
	 * プレイヤー操作方法選択クラス
	 * @type {ThreeEyeGameControlPlayerOperationSelect}
	 */
	this.player_opelation = new ThreeEyeGameControlPlayerOperationSelect();
	
	// プレイヤー操作方法表示
	this.displayPlayerOperation();
	
}

/**
 * 各コントロール更新
 */
ThreeEyeGameControlManage.prototype.updateControl = function(){
	this.comp_num_select.updateCompNum();
	this.player_num_select.updatePlayerNum();
	this.board_height_select.updateBoardHeightNum();
	this.board_width_select.updateBoardWidthNum();
	this.player_opelation.updateOperation();
};

/**
 * いくつ並べるか取得
 * @returns {number} いくつ並べればいいか
 */
ThreeEyeGameControlManage.prototype.getCompNum = function(){
	return this.comp_num_select.getCompNum();
};

/**
 * プレイヤー人数取得
 * @returns {number} プレイヤー人数
 */
ThreeEyeGameControlManage.prototype.getPlayerNum = function(){
	return this.player_num_select.getPlayerNum();
};

/**
 * 盤の縦数取得
 * @returns {number} 盤の縦数
 */
ThreeEyeGameControlManage.prototype.getBoardHeightNum = function(){
	return this.board_height_select.getBoardHeightNum();
};

/**
 * 盤の幅数取得
 * @returns {number} 盤の幅数
 */
ThreeEyeGameControlManage.prototype.getBoardWidthNum = function(){
	return this.board_width_select.getBoardWidthNum();
};

/**
 * プレイヤー操作方法表示
 */
ThreeEyeGameControlManage.prototype.displayPlayerOperation = function(){
	var num = this.player_num_select.getCurrentPlayerNum();
	this.player_opelation.visibleOperation(num);
};

/**
 * プレイヤー操作方法取得
 * @param {number} index プレイヤーインデックス
 * @returns {number} プレイヤー操作方法
 */
ThreeEyeGameControlManage.prototype.getPlayerOperation = function(index){
	return this.player_opelation.getOperation(index);
};

ThreeEyeGameControlManage.prototype.showTitle = function(){
	
	var status_mng = new ThreeEyeGameStatusManage();
	var title = "";
	var num = this.player_num_select.getCurrentPlayerNum();
	for(var id = 1; id < num + 1; id++){
		title = title + status_mng.getStatus(id);
	}
	title = title + "ゲーム";
	
	document.getElementById(THREE_EYE_GAME_DEFINE.TITLE_ID).innerHTML = title;
};