/**
 * プレイヤー操作方法選択クラス
 * @constructor
 */
function ThreeEyeGameControlPlayerOperationSelect(){
	/**
	 * プレイヤー操作方法選択リスト<span>
	 * @type {NodeList}
	 */
	this.player_ope_span_list = document.getElementsByName(THREE_EYE_GAME_DEFINE.PLAYER_OPERATION_ID);
	/**
	 * プレイヤー操作方法選択リスト<select>
	 * @type {NodeList}
	 */
	this.player_ope_select_list = document.getElementsByName(THREE_EYE_GAME_DEFINE.PLAYER_OPERATION_SELECT_ID);
	
	/**
	 * プレイヤー操作方法リスト
	 * @type {Array.<number>}
	 */
	this.player_ope_list = [];
	
	// プレイヤー選択方法更新
	this.updateOperation();
}

/**
 * プレイヤー操作方法更新
 */
ThreeEyeGameControlPlayerOperationSelect.prototype.updateOperation = function(){
	
	for(var ii = 0; ii < this.player_ope_select_list.length; ii++){
		var value = this.player_ope_select_list[ii].value;
		this.player_ope_list[ii] = Number(value);
	}
	
};

/**
 * プレイヤー操作方法取得
 * @param {number} index インデックス
 * @returns {number} プレイヤー操作方法
 */
ThreeEyeGameControlPlayerOperationSelect.prototype.getOperation = function(index){
	return this.player_ope_list[index];
};

/**
 * プレイヤー操作方法表示
 * @param {number} num 表示人数
 */
ThreeEyeGameControlPlayerOperationSelect.prototype.visibleOperation = function(num){
	
	// 全部非表示
	for(var ii = 0; ii < this.player_ope_select_list.length; ii++){
		this.player_ope_select_list[ii].style.display = "none";
	}
	
	// 指定された人数だけ表示
	for(var ii = 0; ii < num; ii++){
		this.player_ope_select_list[ii].style.display = "inline";
	}
};
