
/**
 * プレイヤー人数選択クラス
 * @constructor
 */
function ThreeEyeGameControlPlayerSelect(){
	/**
	 * プレイヤー人数<select>要素
	 * @type {Element}
	 */
	this.player_num_select = document.getElementById(THREE_EYE_GAME_DEFINE.PLAYER_NUM_SELECT_ID);
	/**
	 * プレイヤー人数
	 * @type {number}
	 */
	this.player_num = 2;
	
	// プレイヤー人数更新
	this.updatePlayerNum();
	
	// プレイヤー人数変更ハンドラ登録
	var cross = new CROSS();
	cross.addEvent(this.player_num_select, "change", this.changeHandler);
	cross.addEvent(this.player_num_select, "keyup", this.changeHandler);
}


/**
 * プレイヤー人数取得
 * @returns {number} プレイヤー人数
 */
ThreeEyeGameControlPlayerSelect.prototype.getPlayerNum = function(){
	return this.player_num;
};

/**
 * プレイヤー人数更新
 * 
 */
ThreeEyeGameControlPlayerSelect.prototype.updatePlayerNum = function(){

	var value = this.player_num_select.value;
	this.player_num = Number(value);
};

/**
 * 現在選択されているプレイヤー人数表示
 * @returns {number} 現在選択されているプレイヤー人数
 */
ThreeEyeGameControlPlayerSelect.prototype.getCurrentPlayerNum = function(){
	var value = this.player_num_select.value;
	return Number(value);
};

/**
 * プレイヤー人数変更ハンドラー
 * @param {Event} e エベント
 */
ThreeEyeGameControlPlayerSelect.prototype.changeHandler = function(e){
	g_control.displayPlayerOperation();
	g_control.showTitle();
};
