/**
 * @fileoverview 三目並べゲームデータクラス定義ファイル
 *     三目並べゲームで使用するすべてのデータを保持するクラス。
 */

/**
 * 三目並べゲームデータクラス
 * 
 * @constructor
 */
function ThreeEyeGameData() {
	/**
	 * 盤データ
	 * 
	 * @type {ThreeEyeGameBoardData}
	 */
	this.board = new ThreeEyeGameBoardData();
}

/**
 * 盤データ初期化
 */
ThreeEyeGameData.prototype.initBoardData = function() {
	this.board = new ThreeEyeGameBoardData();
};

/**
 * 盤データ取得
 * 
 * @returns {ThreeEyeGameBoardData} 盤データ
 */
ThreeEyeGameData.prototype.getBoardData = function() {
	return this.board;
};