/**
 * 三目並べゲーム定数定義
 * 
 * @type {ThreeEyeGameDefine}
 */
var THREE_EYE_GAME_DEFINE = new ThreeEyeGameDefine();

/**
 * 三目並べゲーム定数定義クラス
 * 
 * @constructor
 */
function ThreeEyeGameDefine() {
	/**
	 * <canvas>エレメントのID
	 * 
	 * @type {string}
	 */
	this.CANVAS_ID = "three_eye";

	/**
	 * プレイヤーの数
	 * 
	 * @type {number}
	 */
	this.PLAYER_NUM = 4;

	/**
	 * 自分が操作
	 * @type {number}
	 */
	this.PLAY_SELF = 1;
	/**
	 * COMが操作
	 * @type {number}
	 */
	this.PLAY_COM = 2;
	
	/**
	 * 揃える数
	 * 
	 * @type {number}
	 */
	this.COMP_NUM = 3;

	/**
	 * マスの高さ
	 * 
	 * @type {number}
	 */
	this.MASS_HEIGHT = 50;
	/**
	 * マスの幅
	 * 
	 * @type {number}
	 */
	this.MASS_WIDTH = 50;

	/**
	 * 盤の縦方向の個数
	 * 
	 * @type {number}
	 */
	this.BOARD_HEIGHT_NUM = 15;
	/**
	 * 盤の横方向の個数
	 * 
	 * @type {number}
	 */
	this.BOARD_WIDTH_NUM = 15;

	/**
	 * マスの空白状態
	 * 
	 * @type {number}
	 */
	this.MASS_STATUS_SPASE = 0;
	/**
	 * マスの状態：何も置けない
	 * 
	 * @type {number}
	 */
	this.MASS_STATUS_NONE = -1;

	/**
	 * シーン：試合中
	 * 
	 * @type {number}
	 */
	this.SCENE_PLAY = 1;
	/**
	 * シーン：終了
	 * 
	 * @type{number}
	 */
	this.SCENE_FINISH = 2;

	/**
	 * 向き:なし
	 * 
	 * @type {number}
	 */
	this.DIRECTION_NONE = 0;
	/**
	 * 向き:上
	 * 
	 * @type {number}
	 */
	this.DIRECTION_UP = 1;
	/**
	 * 向き:下
	 * 
	 * @type {number}
	 */
	this.DIRECTION_DOWN = 2;
	/**
	 * 向き:左
	 * 
	 * @type {number}
	 */
	this.DIRECTION_LEFT = 3;
	/**
	 * 向き:右
	 * 
	 * @type {number}
	 */
	this.DIRECTION_RIGHT = 4;
	/**
	 * 向き:左上
	 * 
	 * @type {number}
	 */
	this.DIRECTION_LEFT_UP = 5;
	/**
	 * 向き:右上
	 * 
	 * @type {number}
	 */
	this.DIRECTION_RIGHT_UP = 6;
	/**
	 * 向き:左下
	 * 
	 * @type {number}
	 */
	this.DIRECTION_LEFT_DOWN = 7;
	/**
	 * 向き:右下
	 * 
	 * @type {number}
	 */
	this.DIRECTION_RIGHT_DOWN = 8;

	/**
	 * 色:白
	 * 
	 * @type {number}
	 */
	this.COLOR_WHITE = 0;
	/**
	 * 色:黒
	 * 
	 * @type {number}
	 */
	this.COLOR_BLACK = 1;
	/**
	 * 色:赤
	 * 
	 * @type {number}
	 */
	this.COLOR_RED = 2;
	
	/**
	 * タイマーミリ秒
	 * @type {number}
	 */
	this.TIMER_MSEC = 10;
	
	/**
	 * タイトル<div>
	 * @type {string}
	 */
	this.TITLE_ID = "three_game_title";
	/**
	 * コントローラ：いくつ並べればいいか
	 * @type {string}
	 */
	this.COMP_NUM_SELECT_ID = "comp_num_select";
	/**
	 * コントローラ：プレイヤーの人数
	 * @type {string}
	 */
	this.PLAYER_NUM_SELECT_ID = "player_num_select";
	/**
	 * コントローラ：盤の高さの数
	 * @type {string}
	 */
	this.BOARD_HEIGHT_NUM_SELECT_ID = "board_height_num_select";
	/**
	 * コントローラ：盤の幅の数
	 * @type {string}
	 */
	this.BOARD_WIDTH_NUM_SELECT_ID = "bard_width_num_select";
	/**
	 * コントローラ：試合開始ボタン
	 * @type {string}
	 */
	this.START_BUTTON_ID ="start_button";
	/**
	 * コントローラ：操作<span>
	 * @type {string}
	 */
	this.PLAYER_OPERATION_ID = "plaery_operation";
	/**
	 * コントローラ：操作選択<select>
	 * @type {string}
	 */
	this.PLAYER_OPERATION_SELECT_ID = "player_opration_select";
	/**
	 * ログ<div>
	 * @type {string}
	 */
	this.LOG_ID = "three_eye_log";
}
