/**
 * @fileoverview 三目並べゲーム描画クラス定義ファイル
 *     三目並べゲームの描画を担当するクラス。
 */

/**
 * 三目並べゲーム描画クラス
 * 
 * @constructor
 */
function ThreeEyeGameDrawer() {
	/**
	 * コンテキスト
	 * 
	 * @type {CanvasRenderingContext2D}
	 */
	this.ctx = document.getElementById(THREE_EYE_GAME_DEFINE.CANVAS_ID)
			.getContext('2d');
	/**
	 * 盤描画
	 * 
	 * @type {ThreeEyeGameBoardDrawer}
	 */
	this.board = new ThreeEyeGameBoardDrawer();
	
	// キャンパスのサイズ変更
	var canvas = document.getElementById(THREE_EYE_GAME_DEFINE.CANVAS_ID);
	canvas.height = g_control.getBoardHeightNum() * THREE_EYE_GAME_DEFINE.MASS_HEIGHT;
	canvas.width = g_control.getBoardWidthNum() * THREE_EYE_GAME_DEFINE.MASS_WIDTH;
	
}

/**
 * 三目並べゲーム描画
 * 
 * @param {ThreeEyeGameData}
 *            data 三目並べゲームデータ
 */
ThreeEyeGameDrawer.prototype.draw = function(data) {

	// キャンパスエレメント取得
	var canvas = document.getElementById(THREE_EYE_GAME_DEFINE.CANVAS_ID);

	// 初期化
	this.ctx.clearRect(0, 0, canvas.width, canvas.height);

	// ボード情報取得
	var boardData = data.getBoardData();
	// 盤描画
	this.board.draw(boardData);

};