/**
 * 三目並べゲーム直線マス設定クラス 直線にあるマスに同じ設定をする。
 * 
 * @constructor
 */
function ThreeEyeGameLineSetting() {

}

/**
 * 背景色設定
 * 
 * @param {ThreeEyeGameBoardData}
 *            board 盤データ
 * @param {ThreeEyeGameMassData}
 *            mass_data マスデータ
 * @param {number}
 *            direction 方向
 * @param {number}
 *            num 個数
 * @param {number}
 *            color 背景色
 */
ThreeEyeGameLineSetting.prototype.setBackColor = function(board, mass_data,
		direction, num, color) {
	// マスをローカル変数に格納
	// 引数を書き換えるのは怖いので。
	var mass = mass_data;
	// 渡されたマスの背景色を変更する
	mass.setBackColor(color);

	// 残りのマスを設定する
	for ( var ii = 1; ii < num; ii++) {
		// 渡された方向のマスを取得する
		mass = board.getDirectionMass(mass, direction);
		if (mass == null) {
			break;
		}
		// 背景色を設定
		mass.setBackColor(color);
	}
};