/**
 * 三目並べゲームログ表示クラス
 * 
 * @constructor
 */
function ThreeEyeGameLogger() {
	/**
	 * ログ表示エレメント<div>
	 * 
	 * @type {Element}
	 */
	this.log_element = document.getElementById(THREE_EYE_GAME_DEFINE.LOG_ID);
}

/**
 * ログ表示
 * 
 * @param {ThreeEyeGameData}
 *            data 三目ゲームデータ
 * @param {ThreeEyeGameManage}
 *            manage マネージャ
 */
ThreeEyeGameLogger.prototype.write = function(data, manage) {
	// 試合中の場合
	if (manage.getScene() == THREE_EYE_GAME_DEFINE.SCENE_PLAY) {
		var player = manage.getCurrentPlayer();
		var id = player.getId();
		var status_manage = new ThreeEyeGameStatusManage();
		var status = status_manage.getStatus(id);
		this.log_element.innerHTML = "プレイヤー" + String(id) + "(" + status
				+ ")の攻撃中";
	}
	// 試合終了の場合
	else if (manage.getScene() == THREE_EYE_GAME_DEFINE.SCENE_FINISH) {
		var player = manage.getWinner();
		if (player == null) {
			this.log_element.innerHTML = "試合終了。勝者なし。";
		} else {
			var id = player.getId();
			this.log_element.innerHTML = "試合終了。プレイヤー" + String(id) + "の勝ち";
		}
	}
};