/**
 * 三目並べゲームマスデータクラス
 * 
 * @constructor
 * @param {number}
 *            widht_index 横方向インデックス
 * @param {number}
 *            height_index 縦方向インデックス
 */
function ThreeEyeGameMassData(widht_index, height_index) {
	/**
	 * 縦方向インデックス
	 * 
	 * @type {number}
	 */
	this.height_index = height_index;
	/**
	 * 横方向インデックス
	 * 
	 * @type {number}
	 */
	this.widht_index = widht_index;

	/**
	 * 状態
	 * 
	 * @type {number}
	 */
	this.status = THREE_EYE_GAME_DEFINE.MASS_STATUS_SPASE;

	/**
	 * 背景色
	 * 
	 * @type {number}
	 */
	this.back_color = THREE_EYE_GAME_DEFINE.COLOR_WHITE;

	/**
	 * 左上X座標
	 * 
	 * @type {number}
	 */
	this.x = this.widht_index * THREE_EYE_GAME_DEFINE.MASS_WIDTH;
	/**
	 * 左上Y座標
	 * 
	 * @type {number}
	 */
	this.y = this.height_index * THREE_EYE_GAME_DEFINE.MASS_HEIGHT;
}

/**
 * マス状態取得
 * 
 * @return {number} マス状態
 */
ThreeEyeGameMassData.prototype.getMassStatus = function() {
	return this.status;
};

/**
 * マス状態設定
 * 
 * @param {number}
 *            status マス状態
 */
ThreeEyeGameMassData.prototype.setMassStatus = function(status) {
	this.status = status;
};

/**
 * 縦方向インデックス取得
 * 
 * @returns {number} 縦方向インデックス
 */
ThreeEyeGameMassData.prototype.getHeightIndex = function() {
	return this.height_index;
};

/**
 * 横方向インデックス取得
 * 
 * @returns {number} 横方向インデックス
 */
ThreeEyeGameMassData.prototype.getWidthIndex = function() {
	return this.widht_index;
};

/**
 * X座標取得
 * 
 * @returns {number} X座標
 */
ThreeEyeGameMassData.prototype.getX = function() {
	return this.x;
};

/**
 * Y座標取得
 * 
 * @returns {number} Y座標
 */
ThreeEyeGameMassData.prototype.getY = function() {
	return this.y;
};

/**
 * 背景色設定
 * 
 * @param {number}
 *            color 色
 */
ThreeEyeGameMassData.prototype.setBackColor = function(color) {
	this.back_color = color;
};

/**
 * 背景色取得
 * 
 * @returns {number} 色
 */
ThreeEyeGameMassData.prototype.getBackColor = function() {
	return this.back_color;
};
