
/**
 * 三目並べゲームプレイヤークラス
 * @constructor
 * @param {number} id プレイヤー識別子
 * @param {number} operation 操作方法
 */
function ThreeEyeGamePlayer(id, operation){
	/**
	 * 自分の番かどうか
	 * @type {boolean}
	 */
	this.current = false;
	/**
	 * プレイヤー識別子
	 * @type {number}
	 */
	this.id = id;
	/**
	 * 操作方法
	 * @type {number}
	 */
	this.operation = operation;
}

/**
 * 現在プレイ中かどうか
 * @returns {boolean} プレイ中判定
 */
ThreeEyeGamePlayer.prototype.isCurrent = function(){
	return this.current;
};

/**
 * 現在プレイ中かどうか設定する
 * @param {boolean} isCurrent プレイ中真偽
 */
ThreeEyeGamePlayer.prototype.setCurrent = function(isCurrent){
	this.current = isCurrent;
};

/**
 * ID取得
 * @returns {number} ID
 */
ThreeEyeGamePlayer.prototype.getId = function(){
	return this.id;
};

/**
 * 操作方法取得
 * @returns {number} 操作方法
 */
ThreeEyeGamePlayer.prototype.getOperation = function(){
	return this.operation;
};


